<?php

/**
 * Contao Open Source CMS
 *
 * Copyright (c) 2005-2014 Leo Feyer
 *
 * @package News
 * @link    https://contao.org
 * @license http://www.gnu.org/licenses/lgpl-3.0.html LGPL
 */

/**
 * Table tl_chesstournament_results
 */
$GLOBALS['TL_DCA']['tl_chesstournament_results'] = array
(

	// Config
	'config' => array
	(
		'dataContainer'               => 'Table',
		'ptable'                      => 'tl_chesstournament',
		'switchToEdit'                => true,
		'enableVersioning'            => true,
		'sql' => array
		(
			'keys' => array
			(
				'id' => 'primary',
				'pid' => 'index',
			)
		)
	),

	// List
	'list' => array
	(
		'sorting' => array
		(
			'mode'                    => 4,
			'fields'                  => array('round'),
			'headerFields'            => array('title'),
			'panelLayout'             => 'filter;sort,search,limit',
			'child_record_callback'   => array('tl_chesstournament_results', 'listResults'), 
		),
		'global_operations' => array
		(
			'players' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_players']['players'],
				'href'                => 'table=tl_chesstournament_players',
				'icon'                => 'system/modules/chesstournament/assets/images/player.png',
			), 
			'all' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['MSC']['all'],
				'href'                => 'act=select',
				'class'               => 'header_edit_all',
				'attributes'          => 'onclick="Backend.getScrollOffset()" accesskey="e"'
			)
		),
		'operations' => array
		(
			'edit' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['edit'],
				'href'                => 'act=edit',
				'icon'                => 'header.gif'
			),
			'copy' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['copy'],
				'href'                => 'act=paste&amp;mode=copy',
				'icon'                => 'copy.gif'
			),
			'cut' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['cut'],
				'href'                => 'act=paste&amp;mode=cut',
				'icon'                => 'cut.gif'
			),
			'delete' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['delete'],
				'href'                => 'act=delete',
				'icon'                => 'delete.gif',
				'attributes'          => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
			),
			'toggle' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['toggle'],
				'icon'                => 'visible.gif',
				'attributes'          => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
			),
			'show' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['show'],
				'href'                => 'act=show',
				'icon'                => 'show.gif'
			)
		)
	),

	// Palettes
	'palettes' => array
	(
		'__selector__'                => array('addImage', 'addEnclosure', 'source'),
		'default'                     => '{title_legend},round,white,black'
	),

	// Subpalettes
	'subpalettes' => array
	(
		'addImage'                    => 'singleSRC,alt,size,imagemargin,imageUrl,fullsize,caption,floating',
		'addEnclosure'                => 'enclosure',
		'source_internal'             => 'jumpTo',
		'source_article'              => 'articleId',
		'source_external'             => 'url,target'
	),

	// Fields
	'fields' => array
	(
		'id' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL auto_increment"
		),
		'pid' => array
		(
			'foreignKey'              => 'tl_chesstournament.title',
			'sql'                     => "int(10) unsigned NOT NULL default '0'",
			'relation'                => array('type'=>'belongsTo', 'load'=>'eager')
		),
		'tstamp' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL default '0'"
		),
		'round' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['round'],
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('rgxp'=>'digit', 'tl_class'=>'w50'),
			'sql'                     => "smallint(5) unsigned NOT NULL default '0'"
		), 
		'white' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['white'],
			'exclude'                 => true,
			'inputType'               => 'select',
			'options_callback'        => array('tl_chesstournament_results', 'getPlayer'),
			'eval'                    => array
			(
				'mandatory'           => true,
				'chosen'              => true,
				'submitOnChange'      => false,
				'tl_class'            => 'w50 clr'
			),
			'sql'                     => "int(10) unsigned NOT NULL default '0'"
		),
		'black' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_chesstournament_results']['black'],
			'exclude'                 => true,
			'inputType'               => 'select',
			'options_callback'        => array('tl_chesstournament_results', 'getPlayer'),
			'eval'                    => array
			(
				'mandatory'           => true,
				'chosen'              => true,
				'submitOnChange'      => false,
				'tl_class'            => 'w50'
			),
			'sql'                     => "int(10) unsigned NOT NULL default '0'"
		),
	)
);


/**
 * Class tl_chesstournament_results
 *
 * Provide miscellaneous methods that are used by the data configuration array.
 * @copyright  Leo Feyer 2005-2014
 * @author     Leo Feyer <https://contao.org>
 * @package    News
 */
class tl_chesstournament_results extends Backend
{

	var $player = array();
	
	/**
	 * Import the back end user object
	 */
	public function __construct()
	{
		parent::__construct();
		$this->import('BackendUser', 'User');
		
		// Spielerliste des Turniers einlesen
		$objPlayer = $this->Database->prepare("SELECT id, surname, prename FROM tl_chesstournament_players WHERE pid=? ORDER BY surname")->execute($_GET['id']);
		while ($objPlayer->next())
		{
			$this->player[$objPlayer->id] = $objPlayer->surname .','.$objPlayer->prename;
		}

	}

	/**
	 * Add the type of input field
	 * @param array
	 * @return string
	 */
	public function listResults($arrRow)
	{
		$temp = '<div class="tl_content_left">';
		if($arrRow['white']) $temp .= $this->player[$arrRow['white']];
		if($arrRow['black']) $temp .= ' - '.$this->player[$arrRow['black']];
		return $temp.'</div>';
	}

	public function getPlayer(DataContainer $dc)
	{

		$arrForms = array();
		$objForms = $this->Database->prepare("SELECT id, surname, prename FROM tl_chesstournament_players WHERE pid=? ORDER BY surname")->execute($dc->activeRecord->pid);

		while ($objForms->next())
		{
			$arrForms[$objForms->id] = $objForms->surname .', '.$objForms->prename. ' (ID ' . $objForms->id . ')';
		}

		return $arrForms;
	}
 
}
